<?php
require_once __DIR__ . '/../config/config.php';
if (is_logged_in()) { header('Location: /222338Asnan/dashboard.php'); exit; }
$error = flash_get('error');
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin Login - Perpustakaan</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex align-items-center" style="height:100vh;">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-4">
        <div class="card shadow-sm">
          <div class="card-body">
            <h5 class="card-title mb-3">Admin Login</h5>
            <?php if ($error): ?>
            <div class="alert alert-danger small"><?php echo h($error); ?></div>
            <?php endif; ?>
            <form action="process_admin_login.php" method="post" class="needs-validation" novalidate>
              <div class="mb-3">
                <label class="form-label">Username</label>
                <input type="text" name="username" class="form-control" required>
                <div class="invalid-feedback">Username wajib diisi</div>
              </div>
              <div class="mb-3">
                <label class="form-label">Password</label>
                <input type="password" name="password" class="form-control" required>
                <div class="invalid-feedback">Password wajib diisi</div>
              </div>
              <div class="d-grid">
                <button class="btn btn-primary">Login sebagai Admin</button>
              </div>
            </form>
            <p class="mt-3 small text-muted">Hubungi admin untuk akun jika belum punya.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="/222338Asnan/assets/js/main.js"></script>
</body>
</html>