<?php
require_once __DIR__ . '/../config/config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: login.php'); exit;
}
$username = trim($_POST['username'] ?? '');
$password = $_POST['password'] ?? '';
if (!$username || !$password) {
    flash_set('error', 'Username and password required');
    header('Location: login.php'); exit;
}
$stmt = db_prepare('SELECT id_user, nama, username, password, role, status FROM users WHERE username = ? LIMIT 1');
$stmt->bind_param('s', $username);
$stmt->execute();
$res = $stmt->get_result();
$user = $res->fetch_assoc();
if (!$user) {
    flash_set('error', 'User not found'); header('Location: login.php'); exit;
}
if ($user['status'] !== 'aktif') {
    flash_set('error', 'User nonaktif'); header('Location: login.php'); exit;
}
if (!password_verify($password, $user['password'])) {
    flash_set('error', 'Password salah'); header('Location: login.php'); exit;
}
// Login success
$_SESSION['user'] = [
    'id' => $user['id_user'],
    'nama' => $user['nama'],
    'username' => $user['username'],
    'role' => $user['role']
];
header('Location: /222338Asnan/dashboard.php'); exit;
?>