<?php
require_once __DIR__ . '/../config/config.php';
if (is_logged_in()) { header('Location: /222338Asnan/dashboard.php'); exit; }
$error = flash_get('error');
$success = flash_get('success');
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>User Login / Register - Perpustakaan</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex align-items-center" style="height:100vh;">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-6">
        <div class="card shadow-sm">
          <div class="card-body">
            <h5 class="card-title mb-3">Masuk / Daftar Anggota</h5>
            <?php if ($error): ?><div class="alert alert-danger small"><?php echo h($error); ?></div><?php endif; ?>
            <?php if ($success): ?><div class="alert alert-success small"><?php echo h($success); ?></div><?php endif; ?>

            <ul class="nav nav-tabs" id="authTab" role="tablist">
              <li class="nav-item" role="presentation"><button class="nav-link active" id="login-tab" data-bs-toggle="tab" data-bs-target="#login" type="button">Login</button></li>
              <li class="nav-item" role="presentation"><button class="nav-link" id="register-tab" data-bs-toggle="tab" data-bs-target="#register" type="button">Register</button></li>
            </ul>
            <div class="tab-content mt-3">
              <div class="tab-pane fade show active" id="login" role="tabpanel">
                <form action="process_user_login.php" method="post" class="needs-validation" novalidate>
                  <div class="mb-3"><label class="form-label">Username</label><input type="text" name="username" class="form-control" required><div class="invalid-feedback">Username wajib</div></div>
                  <div class="mb-3"><label class="form-label">Password</label><input type="password" name="password" class="form-control" required><div class="invalid-feedback">Password wajib</div></div>
                  <div class="d-grid"><button class="btn btn-primary">Login</button></div>
                </form>
              </div>
              <div class="tab-pane fade" id="register" role="tabpanel">
                <form action="process_register.php" method="post" class="needs-validation" novalidate>
                  <div class="mb-2"><label class="form-label">Nama Lengkap</label><input name="nama" class="form-control" required><div class="invalid-feedback">Wajib</div></div>
                  <div class="mb-2"><label class="form-label">Username</label><input name="username" class="form-control" required><div class="invalid-feedback">Wajib</div></div>
                  <div class="mb-2"><label class="form-label">Password</label><input type="password" name="password" class="form-control" required><div class="invalid-feedback">Wajib</div></div>
                  <div class="mb-2"><label class="form-label">Ulangi Password</label><input type="password" name="password2" class="form-control" required><div class="invalid-feedback">Wajib</div></div>
                  <div class="d-grid"><button class="btn btn-primary">Daftar</button></div>
                </form>
              </div>
            </div>

            <p class="mt-3 small text-muted">Jika Anda adalah admin, gunakan <a href="/222338Asnan/auth/adminlogin.php">Admin Login</a>.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="/222338Asnan/assets/js/main.js"></script>
</body>
</html>