<?php
// config/config.php - global configuration and helpers
session_start();
require_once __DIR__ . '/db.php';

function is_logged_in() {
    return isset($_SESSION['user']);
}

function is_admin() {
    return is_logged_in() && ($_SESSION['user']['role'] === 'admin');
}

function require_login() {
    if (!is_logged_in()) {
        header('Location: /222338Asnan/auth/userlogin.php');
        exit;
    }
}

function flash_set($key, $message) {
    $_SESSION['flash'][$key] = $message;
}

function flash_get($key) {
    if (!isset($_SESSION['flash'][$key])) return null;
    $msg = $_SESSION['flash'][$key];
    unset($_SESSION['flash'][$key]);
    return $msg;
}

function h($s) {
    return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}
?>