<?php
require_once __DIR__ . '/../config/config.php';
require_login();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id_anggota'] ?? 0);
    $nama = trim($_POST['nama_anggota'] ?? '');
    $alamat = trim($_POST['alamat'] ?? '');
    $telp = trim($_POST['no_telp'] ?? '');
    $status = $_POST['status'] ?? 'aktif';
    if (!$nama) { flash_set('error','Nama wajib diisi'); header('Location:anggota.php'); exit; }
    if ($id>0) {
        $stmt = db_prepare('UPDATE anggota SET nama_anggota=?, alamat=?, no_telp=?, status=? WHERE id_anggota=?');
        $stmt->bind_param('sssi',$nama,$alamat,$telp,$status,$id); $stmt->execute(); flash_set('success','Anggota diperbarui'); header('Location:anggota.php'); exit;
    } else {
        $stmt = db_prepare('INSERT INTO anggota (nama_anggota, alamat, no_telp, status) VALUES (?, ?, ?, ?)');
        $stmt->bind_param('ssss',$nama,$alamat,$telp,$status); $stmt->execute(); flash_set('success','Anggota ditambahkan'); header('Location:anggota.php'); exit;
    }
}
if (isset($_GET['delete'])) { if (!is_admin()) { flash_set('error','Akses ditolak'); header('Location:anggota.php'); exit; } $id=intval($_GET['delete']); $stmt=db_prepare('DELETE FROM anggota WHERE id_anggota=?'); $stmt->bind_param('i',$id); $stmt->execute(); flash_set('success','Anggota dihapus'); header('Location:anggota.php'); exit; }
$edit=null; if (isset($_GET['edit'])) { $id=intval($_GET['edit']); $stmt=db_prepare('SELECT * FROM anggota WHERE id_anggota=?'); $stmt->bind_param('i',$id); $stmt->execute(); $edit=$stmt->get_result()->fetch_assoc(); }
$q=trim($_GET['q'] ?? ''); $page=max(1,intval($_GET['page'] ?? 1)); $perPage=10; $offset=($page-1)*$perPage;
$sqlWhere=''; if ($q) $sqlWhere='WHERE nama_anggota LIKE ? OR alamat LIKE ? OR no_telp LIKE ?';
if ($q) { $like="%$q%"; $ts=$mysqli->prepare("SELECT COUNT(*) as total FROM anggota $sqlWhere"); $ts->bind_param('sss',$like,$like,$like); } else { $ts=$mysqli->prepare("SELECT COUNT(*) as total FROM anggota"); }
$ts->execute(); $total=$ts->get_result()->fetch_assoc()['total'];
if ($q) { $stmt = $mysqli->prepare("SELECT * FROM anggota $sqlWhere ORDER BY tanggal_daftar DESC LIMIT ? OFFSET ?"); $stmt->bind_param('sssii',$like,$like,$like,$perPage,$offset); } else { $stmt = $mysqli->prepare("SELECT * FROM anggota ORDER BY tanggal_daftar DESC LIMIT ? OFFSET ?"); $stmt->bind_param('ii',$perPage,$offset); }
$stmt->execute(); $anggota = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
include __DIR__ . '/../template/header.php';
?>
<div class="container">
  <h4>Anggota</h4>
  <?php if ($msg=flash_get('error')): ?><div class="alert alert-danger small"><?php echo h($msg); ?></div><?php endif; ?>
  <?php if ($msg=flash_get('success')): ?><div class="alert alert-success small"><?php echo h($msg); ?></div><?php endif; ?>
  <div class="row">
    <div class="col-md-4">
      <div class="card p-3">
        <h6><?php echo $edit? 'Ubah Anggota':'Tambah Anggota'; ?></h6>
        <form method="post" class="needs-validation" novalidate>
          <input type="hidden" name="id_anggota" value="<?php echo $edit? h($edit['id_anggota']):0; ?>">
          <div class="mb-2"><label class="form-label">Nama</label><input name="nama_anggota" class="form-control" required value="<?php echo $edit? h($edit['nama_anggota']):''; ?>"><div class="invalid-feedback">Wajib</div></div>
          <div class="mb-2"><label class="form-label">Alamat</label><textarea name="alamat" class="form-control"><?php echo $edit? h($edit['alamat']):''; ?></textarea></div>
          <div class="mb-2"><label class="form-label">No. Telp</label><input name="no_telp" class="form-control" value="<?php echo $edit? h($edit['no_telp']):''; ?>"></div>
          <div class="mb-2"><label class="form-label">Status</label><select name="status" class="form-select"><option value="aktif" <?php if ($edit && $edit['status']=='aktif') echo 'selected'; ?>>Aktif</option><option value="nonaktif" <?php if ($edit && $edit['status']=='nonaktif') echo 'selected'; ?>>Nonaktif</option></select></div>
          <div class="d-grid"><button class="btn btn-primary">Simpan</button></div>
        </form>
      </div>
    </div>
    <div class="col-md-8">
      <div class="card p-3">
        <div class="d-flex justify-content-between mb-2">
          <h6>Daftar Anggota</h6>
          <form class="d-flex" method="get"><input name="q" value="<?php echo h($q); ?>" class="form-control form-control-sm me-2" placeholder="Cari..."><button class="btn btn-sm btn-outline-primary">Cari</button></form>
        </div>
        <div class="table-responsive"><table class="table table-sm"><thead><tr><th>#</th><th>Nama</th><th>Telp</th><th>Tanggal Daftar</th><th>Status</th><th>Aksi</th></tr></thead><tbody>
        <?php foreach ($anggota as $i=>$a): ?>
          <tr>
            <td><?php echo $i+1+$offset; ?></td>
            <td><?php echo h($a['nama_anggota']); ?></td>
            <td><?php echo h($a['no_telp']); ?></td>
            <td><?php echo h($a['tanggal_daftar']); ?></td>
            <td><?php echo h($a['status']); ?></td>
            <td>
              <a class="btn btn-sm btn-secondary" href="?edit=<?php echo $a['id_anggota']; ?>">Edit</a>
              <a class="btn btn-sm btn-danger" href="?delete=<?php echo $a['id_anggota']; ?>" onclick="return confirm('Hapus?')">Delete</a>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody></table></div>
        <?php $totalPages = ceil($total/$perPage); if ($totalPages>1): ?><nav><ul class="pagination pagination-sm"><?php for ($p=1;$p<=$totalPages;$p++): ?><li class="page-item <?php echo $p==$page?'active':''; ?>"><a class="page-link" href="?page=<?php echo $p; ?>&q=<?php echo urlencode($q); ?>"><?php echo $p; ?></a></li><?php endfor; ?></ul></nav><?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../template/footer.php'; ?>