<?php
require_once __DIR__ . '/../config/config.php';
require_login();
// Create/Update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id_buku'] ?? 0);
    $id_kategori = intval($_POST['id_kategori'] ?? 0);
    $judul = trim($_POST['judul_buku'] ?? '');
    $penulis = trim($_POST['penulis'] ?? '');
    $tahun = intval($_POST['tahun_terbit'] ?? 0);
    $status = $_POST['status'] ?? 'ada';
    if (!$id_kategori || !$judul || !$penulis || !$tahun) { flash_set('error','Semua field wajib diisi'); header('Location:buku.php'); exit; }
    if ($id>0) {
        $stmt = db_prepare('UPDATE buku SET id_kategori=?, judul_buku=?, penulis=?, tahun_terbit=?, status=? WHERE id_buku=?');
        $stmt->bind_param('issisi',$id_kategori,$judul,$penulis,$tahun,$status,$id); $stmt->execute();
        flash_set('success','Buku diperbarui'); header('Location:buku.php'); exit;
    } else {
        $stmt = db_prepare('INSERT INTO buku (id_kategori, judul_buku, penulis, tahun_terbit, status) VALUES (?,?,?,?,?)');
        $stmt->bind_param('issis',$id_kategori,$judul,$penulis,$tahun,$status); $stmt->execute();
        flash_set('success','Buku ditambahkan'); header('Location:buku.php'); exit;
    }
}
// Delete
if (isset($_GET['delete'])) { if (!is_admin()) { flash_set('error','Akses ditolak'); header('Location:buku.php'); exit; } $id=intval($_GET['delete']); $stmt=db_prepare('DELETE FROM buku WHERE id_buku=?'); $stmt->bind_param('i',$id); $stmt->execute(); flash_set('success','Buku dihapus'); header('Location:buku.php'); exit; }
// Edit
$edit=null; if (isset($_GET['edit'])) { $id=intval($_GET['edit']); $stmt=db_prepare('SELECT * FROM buku WHERE id_buku=?'); $stmt->bind_param('i',$id); $stmt->execute(); $edit=$stmt->get_result()->fetch_assoc(); }
// List
$q = trim($_GET['q'] ?? ''); $page = max(1,intval($_GET['page'] ?? 1)); $perPage=10; $offset=($page-1)*$perPage;
$sqlWhere = '';
if ($q) { $sqlWhere = "WHERE b.judul_buku LIKE ? OR b.penulis LIKE ? OR k.nama_kategori LIKE ?"; }
// total
if ($q) { $like="%$q%"; $ts=$mysqli->prepare("SELECT COUNT(*) as total FROM buku b JOIN kategori k ON b.id_kategori=k.id_kategori $sqlWhere"); $ts->bind_param('sss',$like,$like,$like); }
else { $ts=$mysqli->prepare("SELECT COUNT(*) as total FROM buku"); }
$ts->execute(); $total=$ts->get_result()->fetch_assoc()['total'];
// fetch
if ($q) {
  $stmt = $mysqli->prepare("SELECT b.*, k.nama_kategori FROM buku b JOIN kategori k ON b.id_kategori=k.id_kategori $sqlWhere ORDER BY b.tanggal_input DESC LIMIT ? OFFSET ?");
  $stmt->bind_param('sssii',$like,$like,$like,$perPage,$offset);
} else {
  $stmt = $mysqli->prepare("SELECT b.*, k.nama_kategori FROM buku b JOIN kategori k ON b.id_kategori=k.id_kategori ORDER BY b.tanggal_input DESC LIMIT ? OFFSET ?");
  $stmt->bind_param('ii',$perPage,$offset);
}
$stmt->execute(); $books = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
// categories for form
$cats = $mysqli->query('SELECT * FROM kategori WHERE status="aktif"')->fetch_all(MYSQLI_ASSOC);
include __DIR__ . '/../template/header.php';
?>
<div class="container">
  <h4>Buku</h4>
  <?php if ($msg=flash_get('error')): ?><div class="alert alert-danger small"><?php echo h($msg); ?></div><?php endif; ?>
  <?php if ($msg=flash_get('success')): ?><div class="alert alert-success small"><?php echo h($msg); ?></div><?php endif; ?>
  <div class="row">
    <div class="col-md-4">
      <div class="card p-3">
        <h6><?php echo $edit? 'Ubah Buku':'Tambah Buku'; ?></h6>
        <form method="post" class="needs-validation" novalidate>
          <input type="hidden" name="id_buku" value="<?php echo $edit? h($edit['id_buku']):0; ?>">
          <div class="mb-2">
            <label class="form-label">Kategori</label>
            <select class="form-select" name="id_kategori" required>
              <option value="">-- Pilih --</option>
              <?php foreach ($cats as $c): ?>
                <option value="<?php echo $c['id_kategori']; ?>" <?php if ($edit && $edit['id_kategori']==$c['id_kategori']) echo 'selected'; ?>><?php echo h($c['nama_kategori']); ?></option>
              <?php endforeach; ?>
            </select>
            <div class="invalid-feedback">Pilih kategori</div>
          </div>
          <div class="mb-2"><label class="form-label">Judul</label><input name="judul_buku" required class="form-control" value="<?php echo $edit? h($edit['judul_buku']):''; ?>"><div class="invalid-feedback">Wajib</div></div>
          <div class="mb-2"><label class="form-label">Penulis</label><input name="penulis" required class="form-control" value="<?php echo $edit? h($edit['penulis']):''; ?>"></div>
          <div class="mb-2"><label class="form-label">Tahun Terbit</label><input type="number" min="1900" max="2100" name="tahun_terbit" required class="form-control" value="<?php echo $edit? h($edit['tahun_terbit']):''; ?>"></div>
          <div class="mb-2"><label class="form-label">Status</label><select name="status" class="form-select"><option value="ada" <?php if ($edit && $edit['status']=='ada') echo 'selected'; ?>>Ada</option><option value="dipinjam" <?php if ($edit && $edit['status']=='dipinjam') echo 'selected'; ?>>Dipinjam</option></select></div>
          <div class="d-grid"><button class="btn btn-primary">Simpan</button></div>
        </form>
      </div>
    </div>
    <div class="col-md-8">
      <div class="card p-3">
        <div class="d-flex justify-content-between mb-2">
          <h6>Daftar Buku</h6>
          <form class="d-flex" method="get"><input name="q" value="<?php echo h($q); ?>" class="form-control form-control-sm me-2" placeholder="Cari judul/penulis/kategori"><button class="btn btn-sm btn-outline-primary">Cari</button></form>
        </div>
        <div class="table-responsive"><table class="table table-sm"><thead><tr><th>#</th><th>Judul</th><th>Kategori</th><th>Penulis</th><th>Tahun</th><th>Status</th><th>Aksi</th></tr></thead><tbody>
        <?php foreach ($books as $i=>$b): ?>
          <tr>
            <td><?php echo $i+1+$offset; ?></td>
            <td><?php echo h($b['judul_buku']); ?></td>
            <td><?php echo h($b['nama_kategori']); ?></td>
            <td><?php echo h($b['penulis']); ?></td>
            <td><?php echo h($b['tahun_terbit']); ?></td>
            <td><?php echo h($b['status']); ?></td>
            <td>
              <a class="btn btn-sm btn-secondary" href="?edit=<?php echo $b['id_buku']; ?>">Edit</a>
              <a class="btn btn-sm btn-danger" href="?delete=<?php echo $b['id_buku']; ?>" onclick="return confirm('Hapus?')">Delete</a>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody></table></div>
        <?php $totalPages = ceil($total/$perPage); if ($totalPages>1): ?><nav><ul class="pagination pagination-sm"> <?php for ($p=1;$p<=$totalPages;$p++): ?> <li class="page-item <?php echo $p==$page?'active':''; ?>"><a class="page-link" href="?page=<?php echo $p; ?>&q=<?php echo urlencode($q); ?>"><?php echo $p; ?></a></li> <?php endfor; ?></ul></nav><?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../template/footer.php'; ?>