<?php
require_once __DIR__ . '/../config/config.php';
require_login();
if (!is_admin()) {
    // only admin can modify data
}
// Handle create/update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nama = trim($_POST['nama_kategori'] ?? '');
    $deskripsi = trim($_POST['deskripsi'] ?? '');
    $status = $_POST['status'] ?? 'aktif';
    $id = intval($_POST['id_kategori'] ?? 0);
    if (!$nama) { flash_set('error', 'Nama kategori wajib diisi'); header('Location: kategori.php'); exit; }
    if ($id > 0) {
        // update
        $stmt = db_prepare('UPDATE kategori SET nama_kategori=?, deskripsi=?, status=? WHERE id_kategori=?');
        $stmt->bind_param('sssi', $nama, $deskripsi, $status, $id);
        $stmt->execute();
        flash_set('success', 'Kategori diperbarui'); header('Location: kategori.php'); exit;
    } else {
        // insert
        $stmt = db_prepare('INSERT INTO kategori (nama_kategori, deskripsi, status) VALUES (?, ?, ?)');
        $stmt->bind_param('sss', $nama, $deskripsi, $status);
        $stmt->execute();
        flash_set('success', 'Kategori ditambahkan'); header('Location: kategori.php'); exit;
    }
}
// Delete
if (isset($_GET['delete'])) {
    if (!is_admin()) { flash_set('error','Akses ditolak'); header('Location:kategori.php'); exit; }
    $id = intval($_GET['delete']);
    $stmt = db_prepare('DELETE FROM kategori WHERE id_kategori=?');
    $stmt->bind_param('i',$id); $stmt->execute();
    flash_set('success','Kategori dihapus'); header('Location:kategori.php'); exit;
}
// For edit fetch
$edit = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $stmt = db_prepare('SELECT * FROM kategori WHERE id_kategori=? LIMIT 1');
    $stmt->bind_param('i',$id); $stmt->execute(); $res = $stmt->get_result(); $edit = $res->fetch_assoc();
}
// Search & pagination
$q = trim($_GET['q'] ?? '');
$page = max(1, intval($_GET['page'] ?? 1)); $perPage = 10; $offset = ($page-1)*$perPage;
$params = [];
$sqlWhere = '';
if ($q) { $sqlWhere = "WHERE nama_kategori LIKE ? OR deskripsi LIKE ?"; }
$totalStmt = $mysqli->prepare("SELECT COUNT(*) as total FROM kategori $sqlWhere");
if ($q) { $like = "%$q%"; $totalStmt->bind_param('ss',$like,$like); }
$totalStmt->execute(); $total = $totalStmt->get_result()->fetch_assoc()['total'];
$stmt = $mysqli->prepare("SELECT * FROM kategori $sqlWhere ORDER BY tanggal_input DESC LIMIT ? OFFSET ?");
if ($q) { $stmt->bind_param('ssii',$like,$like,$perPage,$offset); } else { $stmt->bind_param('ii',$perPage,$offset); }
$stmt->execute(); $res = $stmt->get_result();
$categories = $res->fetch_all(MYSQLI_ASSOC);
include __DIR__ . '/../template/header.php';
?>
<div class="container">
  <h4>Kategori</h4>
  <?php if ($msg = flash_get('error')): ?>
    <div class="alert alert-danger small"><?php echo h($msg); ?></div>
  <?php endif; ?>
  <?php if ($msg = flash_get('success')): ?>
    <div class="alert alert-success small"><?php echo h($msg); ?></div>
  <?php endif; ?>

  <div class="row">
    <div class="col-md-4">
      <div class="card p-3">
        <h6><?php echo $edit? 'Ubah Kategori':'Tambah Kategori'; ?></h6>
        <form method="post" class="needs-validation" novalidate>
          <input type="hidden" name="id_kategori" value="<?php echo $edit? h($edit['id_kategori']):0; ?>">
          <div class="mb-2">
            <label class="form-label">Nama Kategori</label>
            <input name="nama_kategori" class="form-control" required value="<?php echo $edit? h($edit['nama_kategori']):''; ?>">
            <div class="invalid-feedback">Wajib diisi</div>
          </div>
          <div class="mb-2">
            <label class="form-label">Deskripsi</label>
            <textarea name="deskripsi" class="form-control"><?php echo $edit? h($edit['deskripsi']):''; ?></textarea>
          </div>
          <div class="mb-2">
            <label class="form-label">Status</label>
            <select name="status" class="form-select">
              <option value="aktif" <?php if ($edit && $edit['status']=='aktif') echo 'selected'; ?>>Aktif</option>
              <option value="nonaktif" <?php if ($edit && $edit['status']=='nonaktif') echo 'selected'; ?>>Nonaktif</option>
            </select>
          </div>
          <div class="d-grid"><button class="btn btn-primary">Simpan</button></div>
        </form>
      </div>
    </div>

    <div class="col-md-8">
      <div class="card p-3">
        <div class="d-flex justify-content-between mb-2">
          <h6>Daftar Kategori</h6>
          <form class="d-flex" method="get">
            <input name="q" value="<?php echo h($q); ?>" class="form-control form-control-sm me-2" placeholder="Cari...">
            <button class="btn btn-sm btn-outline-primary">Cari</button>
          </form>
        </div>
        <div class="table-responsive">
          <table class="table table-sm">
            <thead><tr><th>#</th><th>Nama</th><th>Deskripsi</th><th>Status</th><th>Aksi</th></tr></thead>
            <tbody>
            <?php foreach ($categories as $i => $c): ?>
              <tr>
                <td><?php echo $i+1+$offset; ?></td>
                <td><?php echo h($c['nama_kategori']); ?></td>
                <td><?php echo h($c['deskripsi']); ?></td>
                <td><?php echo h($c['status']); ?></td>
                <td>
                  <a class="btn btn-sm btn-secondary" href="?edit=<?php echo $c['id_kategori']; ?>">Edit</a>
                  <a class="btn btn-sm btn-danger" href="?delete=<?php echo $c['id_kategori']; ?>" onclick="return confirm('Hapus?')">Delete</a>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
        <!-- pagination -->
        <?php $totalPages = ceil($total/$perPage); if ($totalPages>1): ?>
          <nav><ul class="pagination pagination-sm">
            <?php for ($p=1;$p<=$totalPages;$p++): ?>
            <li class="page-item <?php echo $p==$page?'active':''; ?>"><a class="page-link" href="?page=<?php echo $p; ?>&q=<?php echo urlencode($q); ?>"><?php echo $p; ?></a></li>
            <?php endfor; ?>
          </ul></nav>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../template/footer.php'; ?>