<?php
require_once __DIR__ . '/../config/config.php';
// Ensure logged in for pages that include header (except login page)
// Some pages like login may not include this header
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Perpustakaan - Dashboard</title>
  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="/222338Asnan/assets/css/custom.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container-fluid">
    <a class="navbar-brand" href="/222338Asnan/dashboard.php">Perpustakaan</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarsExample05">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarsExample05">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
        <?php if (is_logged_in()): ?>
        <li class="nav-item">
          <span class="nav-link">Halo, <strong><?php echo h($_SESSION['user']['nama']); ?></strong></span>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="/222338Asnan/auth/logout.php">Logout</a>
        </li>
        <?php else: ?>
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="loginMenu" role="button" data-bs-toggle="dropdown">Login</a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="loginMenu">
            <li><a class="dropdown-item" href="/222338Asnan/auth/adminlogin.php">Admin Login</a></li>
            <li><a class="dropdown-item" href="/222338Asnan/auth/userlogin.php">User Login / Register</a></li>
          </ul>
        </li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>
<div class="container-fluid">
  <div class="row">
    <aside class="col-md-2 p-0">
      <?php include __DIR__ . '/sidebar.php'; ?>
    </aside>
    <main class="col-md-10 py-3">
