<?php
require_once __DIR__ . '/../config/config.php';
require_login();
// Handle create loan
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_anggota = intval($_POST['id_anggota'] ?? 0);
    $tanggal_pinjam = $_POST['tanggal_pinjam'] ?? '';
    $tanggal_kembali = $_POST['tanggal_kembali'] ?? '';
    $book_ids = $_POST['books'] ?? [];
    if (!$id_anggota || !$tanggal_pinjam || !$tanggal_kembali || empty($book_ids)) { flash_set('error','Semua field wajib diisi'); header('Location:peminjaman.php'); exit; }
    if ($tanggal_kembali < $tanggal_pinjam) { flash_set('error','Tanggal kembali harus >= tanggal pinjam'); header('Location:peminjaman.php'); exit; }
    // check books availability
    $available_ok = true;
    foreach ($book_ids as $bid) {
        $stmt = db_prepare('SELECT status FROM buku WHERE id_buku=? LIMIT 1'); $stmt->bind_param('i',$bid); $stmt->execute(); $b = $stmt->get_result()->fetch_assoc();
        if (!$b || $b['status'] === 'dipinjam') { $available_ok=false; break; }
    }
    if (!$available_ok) { flash_set('error','Salah satu buku tidak tersedia'); header('Location:peminjaman.php'); exit; }
    // insert peminjaman
    $userId = $_SESSION['user']['id'];
    $stmt = db_prepare('INSERT INTO peminjaman (id_anggota, id_user, tanggal_pinjam, tanggal_kembali, status) VALUES (?,?,?,?,"dipinjam")');
    $stmt->bind_param('iiss',$id_anggota, $userId, $tanggal_pinjam, $tanggal_kembali); $stmt->execute(); $id_peminjaman = $mysqli->insert_id;
    foreach ($book_ids as $bid) {
        $stmt = db_prepare('INSERT INTO detail_peminjaman (id_peminjaman, id_buku, qty, status) VALUES (?,?,1,"dipinjam")'); $stmt->bind_param('ii',$id_peminjaman,$bid); $stmt->execute();
        // update buku status
        $u = db_prepare('UPDATE buku SET status="dipinjam" WHERE id_buku=?'); $u->bind_param('i',$bid); $u->execute();
    }
    flash_set('success','Peminjaman berhasil dibuat'); header('Location:peminjaman.php'); exit;
}
// list active peminjaman for quick management
$loans = $mysqli->query('SELECT p.*, a.nama_anggota, u.nama as petugas FROM peminjaman p JOIN anggota a ON p.id_anggota=a.id_anggota JOIN users u ON p.id_user=u.id_user ORDER BY p.tanggal_pinjam DESC')->fetch_all(MYSQLI_ASSOC);
$anggota = $mysqli->query('SELECT * FROM anggota WHERE status="aktif"')->fetch_all(MYSQLI_ASSOC);
$buku_available = $mysqli->query('SELECT * FROM buku WHERE status="ada"')->fetch_all(MYSQLI_ASSOC);
include __DIR__ . '/../template/header.php';
?>
<div class="container">
  <h4>Peminjaman</h4>
  <?php if ($msg=flash_get('error')): ?><div class="alert alert-danger small"><?php echo h($msg); ?></div><?php endif; ?>
  <?php if ($msg=flash_get('success')): ?><div class="alert alert-success small"><?php echo h($msg); ?></div><?php endif; ?>
  <div class="row">
    <div class="col-md-6">
      <div class="card p-3">
        <h6>Form Peminjaman</h6>
        <form method="post" class="needs-validation" novalidate>
          <div class="mb-2"><label class="form-label">Anggota</label><select name="id_anggota" class="form-select" required><option value="">-- Pilih --</option><?php foreach($anggota as $a): ?><option value="<?php echo $a['id_anggota']; ?>"><?php echo h($a['nama_anggota']); ?></option><?php endforeach; ?></select></div>
          <div class="mb-2"><label class="form-label">Tanggal Pinjam</label><input type="date" name="tanggal_pinjam" required class="form-control" value="<?php echo date('Y-m-d'); ?>"></div>
          <div class="mb-2"><label class="form-label">Tanggal Kembali</label><input type="date" name="tanggal_kembali" required class="form-control" value="<?php echo date('Y-m-d', strtotime('+7 days')); ?>"></div>
          <div class="mb-2"><label class="form-label">Pilih Buku (ceklist)</label>
            <?php if (empty($buku_available)): ?><div class="text-muted small">Tidak ada buku tersedia</div><?php else: ?>
            <?php foreach ($buku_available as $b): ?>
              <div class="form-check">
                <input class="form-check-input" type="checkbox" name="books[]" value="<?php echo $b['id_buku']; ?>" id="b<?php echo $b['id_buku']; ?>">
                <label class="form-check-label" for="b<?php echo $b['id_buku']; ?>"><?php echo h($b['judul_buku']); ?> - <?php echo h($b['penulis']); ?></label>
              </div>
            <?php endforeach; ?>
            <?php endif; ?>
          </div>
          <div class="d-grid"><button class="btn btn-primary">Pinjam</button></div>
        </form>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card p-3">
        <h6>Riwayat Peminjaman</h6>
        <div class="table-responsive"><table class="table table-sm"><thead><tr><th>#</th><th>Anggota</th><th>Pinjam</th><th>Kembali</th><th>Status</th></tr></thead><tbody>
        <?php foreach ($loans as $i=>$l): ?>
          <tr><td><?php echo $i+1; ?></td><td><?php echo h($l['nama_anggota']); ?></td><td><?php echo h($l['tanggal_pinjam']); ?></td><td><?php echo h($l['tanggal_kembali']); ?></td><td><?php echo h($l['status']); ?></td></tr>
        <?php endforeach; ?>
        </tbody></table></div>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../template/footer.php'; ?>