<?php
require_once __DIR__ . '/../config/config.php';
require_login();
// Handle return
if (isset($_POST['return'])) {
    $id = intval($_POST['id_peminjaman'] ?? 0);
    if (!$id) { flash_set('error','Invalid request'); header('Location:pengembalian.php'); exit; }
    // fetch details
    $stmt = db_prepare('SELECT id_buku FROM detail_peminjaman WHERE id_peminjaman=? AND status="dipinjam"'); $stmt->bind_param('i',$id); $stmt->execute(); $res = $stmt->get_result(); $rows = $res->fetch_all(MYSQLI_ASSOC);
    if (empty($rows)) { flash_set('error','Tidak ada buku yang perlu dikembalikan'); header('Location:pengembalian.php'); exit; }
    // update detail and buku
    $u1 = db_prepare('UPDATE detail_peminjaman SET status="kembali" WHERE id_peminjaman=? AND status="dipinjam"'); $u1->bind_param('i',$id); $u1->execute();
    foreach ($rows as $r) { $u2 = db_prepare('UPDATE buku SET status="ada" WHERE id_buku=?'); $u2->bind_param('i',$r['id_buku']); $u2->execute(); }
    $u3 = db_prepare('UPDATE peminjaman SET status="kembali" WHERE id_peminjaman=?'); $u3->bind_param('i',$id); $u3->execute();
    flash_set('success','Pengembalian tercatat'); header('Location:pengembalian.php'); exit;
}
// List active loans
$active = $mysqli->query('SELECT p.*, a.nama_anggota FROM peminjaman p JOIN anggota a ON p.id_anggota=a.id_anggota WHERE p.status="dipinjam" ORDER BY p.tanggal_pinjam DESC')->fetch_all(MYSQLI_ASSOC);
include __DIR__ . '/../template/header.php';
?>
<div class="container">
  <h4>Pengembalian</h4>
  <?php if ($msg=flash_get('error')): ?><div class="alert alert-danger small"><?php echo h($msg); ?></div><?php endif; ?>
  <?php if ($msg=flash_get('success')): ?><div class="alert alert-success small"><?php echo h($msg); ?></div><?php endif; ?>
  <div class="card p-3">
    <h6>Peminjaman Aktif</h6>
    <div class="table-responsive"><table class="table table-sm"><thead><tr><th>#</th><th>Anggota</th><th>Pinjam</th><th>Kembali</th><th>Aksi</th></tr></thead><tbody>
    <?php foreach ($active as $i=>$a): ?>
      <tr>
        <td><?php echo $i+1; ?></td>
        <td><?php echo h($a['nama_anggota']); ?></td>
        <td><?php echo h($a['tanggal_pinjam']); ?></td>
        <td><?php echo h($a['tanggal_kembali']); ?></td>
        <td>
          <form method="post" style="display:inline" onsubmit="return confirm('Tandai sebagai dikembalikan?')">
            <input type="hidden" name="id_peminjaman" value="<?php echo $a['id_peminjaman']; ?>">
            <button class="btn btn-sm btn-success" name="return">Kembalikan</button>
          </form>
          <a class="btn btn-sm btn-secondary" href="/222338Asnan/transaksi/detail_peminjaman.php?id=<?php echo $a['id_peminjaman']; ?>">Detail</a>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody></table></div>
  </div>
</div>
<?php include __DIR__ . '/../template/footer.php'; ?>